/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.jei;

import com.almostreliable.summoningrituals.Setup;
import com.almostreliable.summoningrituals.compat.jei.AlmostJEI;
import com.almostreliable.summoningrituals.compat.jei.ingredient.block.BlockReferenceRenderer;
import com.almostreliable.summoningrituals.compat.jei.ingredient.item.AltarRenderer;
import com.almostreliable.summoningrituals.compat.jei.ingredient.item.CatalystRenderer;
import com.almostreliable.summoningrituals.compat.jei.ingredient.mob.MobIngredient;
import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.component.IngredientStack;
import com.almostreliable.summoningrituals.recipe.component.RecipeOutputs;
import com.almostreliable.summoningrituals.recipe.component.RecipeSacrifices;
import com.almostreliable.summoningrituals.util.GameUtils;
import com.almostreliable.summoningrituals.util.TextUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;

public class AltarCategory
implements IRecipeCategory<AltarRecipe> {
    static final RecipeType<AltarRecipe> TYPE = new RecipeType(TextUtils.getRL("altar"), AltarRecipe.class);
    private static final ResourceLocation TEXTURE = TextUtils.getRL(TextUtils.f("textures/{}/{}.png", "jei", "altar"));
    private static final int TEXTURE_WIDTH = 188;
    private static final int TEXTURE_HEIGHT = 148;
    private static final int ITEM_SLOT_SIZE = 18;
    private static final int BLOCK_SLOT_SIZE = 22;
    private static final int SPRITE_SLOT_SIZE = 16;
    private static final int SPRITE_SIZE = 14;
    private static final int CENTER_X = 87;
    private static final int RENDER_Y = 64;
    private static final int INPUT_RADIUS = 47;
    private final AltarRenderer altarRenderer;
    private final CatalystRenderer catalystRenderer;
    private final BlockReferenceRenderer blockReferenceRenderer;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable spriteSlot;
    private final IDrawable daySprite;
    private final IDrawable nightSprite;
    private final IDrawable sunSprite;
    private final IDrawable rainSprite;
    private final IDrawable thunderSprite;

    AltarCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 172, 148).setTextureSize(188, 148).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Setup.ALTAR_ITEM.get()));
        this.altarRenderer = new AltarRenderer(20);
        this.catalystRenderer = new CatalystRenderer(16);
        this.blockReferenceRenderer = new BlockReferenceRenderer(20);
        this.spriteSlot = this.spriteTexture(guiHelper, 0, 16, 16);
        this.daySprite = this.spriteTexture(guiHelper, 16, 14, 14);
        this.nightSprite = this.spriteTexture(guiHelper, 30, 14, 14);
        this.sunSprite = this.spriteTexture(guiHelper, 44, 14, 14);
        this.rainSprite = this.spriteTexture(guiHelper, 58, 14, 14);
        this.thunderSprite = this.spriteTexture(guiHelper, 72, 14, 14);
    }

    private IDrawable spriteTexture(IGuiHelper guiHelper, int v, int width, int height) {
        return guiHelper.drawableBuilder(TEXTURE, 172, v, width, height).setTextureSize(188, 148).build();
    }

    private Component requirementTooltip(String translationKey, String value) {
        return TextUtils.translate("tooltip", translationKey, ChatFormatting.AQUA).m_130946_(": ").m_7220_((Component)TextUtils.translate(translationKey, value.toLowerCase(), ChatFormatting.WHITE));
    }

    private boolean isWithinRequirement(double mX, double mY, int y) {
        return GameUtils.isWithinBounds(mX, mY, 155, y, 16, 16);
    }

    public RecipeType<AltarRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return TextUtils.translate("block", "altar", new ChatFormatting[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AltarRecipe recipe, IFocusGroup focuses) {
        if (recipe.getBlockBelow() != null) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 76, 61).setCustomRenderer(AlmostJEI.AlmostTypes.BLOCK_REFERENCE, (IIngredientRenderer)this.blockReferenceRenderer).addIngredient(AlmostJEI.AlmostTypes.BLOCK_REFERENCE, (Object)recipe.getBlockBelow());
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 78, 32).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)this.catalystRenderer).addIngredients(recipe.getCatalyst());
        NonNullList<IngredientStack> itemInputs = recipe.getInputs();
        RecipeSacrifices mobInputs = recipe.getSacrifices();
        int inputSlots = itemInputs.size() + mobInputs.size();
        for (int i2 = 0; i2 < inputSlots; ++i2) {
            int x = 87 + (int)(Math.cos((double)(i2 * 2) * Math.PI / (double)inputSlots) * 47.0) - 9;
            int y = 64 + (int)(Math.sin((double)(i2 * 2) * Math.PI / (double)inputSlots) * 47.0) - 9;
            if (i2 < itemInputs.size()) {
                ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
                for (ItemStack stack : ((IngredientStack)itemInputs.get(i2)).ingredient().m_43908_()) {
                    stack.m_41764_(((IngredientStack)itemInputs.get(i2)).count());
                    inputStacks.add(stack);
                }
                builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(inputStacks);
                continue;
            }
            RecipeSacrifices.Sacrifice mobInput = mobInputs.get(i2 - itemInputs.size());
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredient(AlmostJEI.AlmostTypes.MOB, (Object)new MobIngredient(mobInput.mob(), mobInput.count()));
        }
        recipe.getOutputs().forEach((type, output, i) -> {
            int x = 2 + i * 17;
            int y = 130;
            if (type == RecipeOutputs.OutputType.ITEM) {
                builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack((ItemStack)output.getOutput());
            } else if (type == RecipeOutputs.OutputType.MOB) {
                MobIngredient entityIngredient = new MobIngredient((EntityType)output.getOutput(), output.getCount(), output.getData());
                builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addIngredient(AlmostJEI.AlmostTypes.MOB, (Object)entityIngredient);
                SpawnEggItem egg = entityIngredient.getEgg();
                if (egg != null) {
                    builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(egg.m_7968_());
                }
            }
        });
    }

    public void draw(AltarRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        stack.m_85836_();
        float altarY = 53.0f - (float)(recipe.getBlockBelow() == null ? 0 : 4);
        stack.m_85837_(76.0, (double)altarY, 0.0);
        this.altarRenderer.render(stack);
        stack.m_85849_();
        GameUtils.renderText(stack, TextUtils.f("{}:", TextUtils.translateAsString("label", "outputs")), GameUtils.ANCHOR.BOTTOM_LEFT, 2, 128, 1.0f, 3580928);
        if (!recipe.getSacrifices().isEmpty()) {
            GameUtils.renderText(stack, TextUtils.f("{}:", TextUtils.translateAsString("label", "region")), GameUtils.ANCHOR.TOP_LEFT, 1, 1, 1.0f, 41727);
            GameUtils.renderText(stack, recipe.getSacrifices().getDisplayRegion(), GameUtils.ANCHOR.TOP_LEFT, 1, 11, 1.0f, 0xFFFFFF);
        }
        int spriteOffset = 1;
        if (recipe.getDayTime() != AltarRecipe.DAY_TIME.ANY) {
            this.spriteSlot.draw(stack, 155, spriteOffset);
            if (recipe.getDayTime() == AltarRecipe.DAY_TIME.DAY) {
                this.daySprite.draw(stack, 156, spriteOffset + 1);
            } else if (recipe.getDayTime() == AltarRecipe.DAY_TIME.NIGHT) {
                this.nightSprite.draw(stack, 156, spriteOffset + 1);
            }
            spriteOffset += 17;
        }
        if (recipe.getWeather() != AltarRecipe.WEATHER.ANY) {
            this.spriteSlot.draw(stack, 155, spriteOffset);
            switch (recipe.getWeather()) {
                case CLEAR: {
                    this.sunSprite.draw(stack, 156, spriteOffset + 1);
                    break;
                }
                case RAIN: {
                    this.rainSprite.draw(stack, 156, spriteOffset + 1);
                    break;
                }
                case THUNDER: {
                    this.thunderSprite.draw(stack, 156, spriteOffset + 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + recipe.getWeather());
                }
            }
        }
    }

    public List<Component> getTooltipStrings(AltarRecipe recipe, IRecipeSlotsView recipeSlotsView, double mX, double mY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (!recipe.getSacrifices().isEmpty() && GameUtils.isWithinBounds(mX, mY, 1, 1, 30, 20)) {
            tooltip.add((Component)TextUtils.translate("tooltip", "region", ChatFormatting.WHITE));
        }
        if (this.isWithinRequirement(mX, mY, 1)) {
            if (recipe.getDayTime() != AltarRecipe.DAY_TIME.ANY) {
                tooltip.add(this.requirementTooltip("day_time", recipe.getDayTime().name()));
            } else if (recipe.getWeather() != AltarRecipe.WEATHER.ANY) {
                tooltip.add(this.requirementTooltip("weather", recipe.getWeather().name()));
            }
        }
        if (this.isWithinRequirement(mX, mY, 18) && recipe.getWeather() != AltarRecipe.WEATHER.ANY) {
            tooltip.add(this.requirementTooltip("weather", recipe.getWeather().name()));
        }
        return tooltip;
    }

    public ResourceLocation getUid() {
        return TYPE.getUid();
    }

    public Class<? extends AltarRecipe> getRecipeClass() {
        return TYPE.getRecipeClass();
    }
}

